/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: cxxabi.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_CXXABI_H
#define __PALMSOURCE_CC_HDR_CXXABI_H

#include <cstddef> /* for std::size_t */
#include <typeinfo> /* for std::type_info */

namespace __cxxabiv1 {}
namespace abi = __cxxabiv1;

namespace __cxxabiv1 {

	extern "C" void __cxa_pure_virtual();

	extern "C" void __cxa_bad_cast();
	extern "C" void __cxa_bad_typeid();

	extern "C" int __cxa_guard_acquire ( void *guard_object_ptr );
	extern "C" void __cxa_guard_release ( void *guard_object_ptr );
	extern "C" void __cxa_guard_abort ( void *guard_object_ptr );
	
	extern "C" int __cxa_atexit ( void (*f)(void*), void *p, void *d );
	extern "C" void __cxa_finalize ( void *d );

	/* Not currently implemented */
        extern "C" char* __cxa_demangle (const char* mangled_name,
				   char* buf,
				   size_t* n,
				   int* status);
	
	extern "C" void * __cxa_vec_new (
		std::size_t element_count,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*constructor) ( void *_this ),
		void* (*destructor) ( void *_this ) );

	extern "C" void * __cxa_vec_new2 (
		std::size_t element_count,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*constructor) ( void *_this ),
		void* (*destructor) ( void *_this ),
		void* (*alloc) ( std::size_t size ),
		void (*dealloc) ( void *obj ) );

	extern "C" void * __cxa_vec_new3 (
		std::size_t element_count,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*constructor) ( void *_this ),
		void* (*destructor) ( void *_this ),
		void* (*alloc) ( std::size_t size ),
		void (*dealloc) ( void *obj, std::size_t size ) );
	
	extern "C" void * __cxa_vec_ctor (
		void *array_address,
		std::size_t element_count,
		std::size_t element_size,
		void* (*constructor) ( void *_this ),
		void* (*destructor) ( void *_this ) );
	
	extern "C" void __cxa_vec_dtor (
		void *array_address,
		std::size_t element_count,
		std::size_t element_size,
		void* (*destructor) ( void *_this ) );
	
	extern "C" void __cxa_vec_cleanup (
		void *array_address,
		std::size_t element_count,
		std::size_t element_size,
		void* (*destructor) (void *_this));
	
	extern "C" void __cxa_vec_delete (
		void *array_address,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*destructor) ( void *_this ) );
	
	extern "C" void __cxa_vec_delete2 (
		void *array_address,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*destructor) ( void *_this ),
		void (*dealloc) ( void *obj ) );
	
	extern "C" void __cxa_vec_delete3 (
		void *array_address,
		std::size_t element_size,
		std::size_t padding_size,
		void* (*destructor) ( void *_this ),
		void (*dealloc) ( void *obj, std::size_t size ) );
	
	extern "C" void * __cxa_vec_cctor (
		void *dest_array,
		void *src_array,
		std::size_t element_count,
		std::size_t element_size,
		void* (*constructor) (void *destination, void *source),
		void* (*destructor) (void *));

	extern "C" void * __aeabi_vec_ctor_nocookie_nodtor(
		void * user_array,
		void * (*constructor)(void*),
		size_t element_size,
		size_t element_count);
	
	extern "C" void * __aeabi_vec_ctor_cookie_nodtor(
		void * cookie_address,
		void * (*constructor)(void*),
		size_t element_size,
		size_t element_count);
	
	extern "C" void __aeabi_vec_dtor (
		void *array_address,
		void* (*destructor) ( void *_this ) );
	
	extern "C" void __aeabi_vec_delete3 (
		void * user_array,
		void * (*destructor)(void*),
		void (*dealloc)(void*, std::size_t));
	
	extern "C" void __aeabi_vec_delete2 (
		void * user_array,
		void * (*destructor)(void*),
		void (*dealloc)(void*));
	
	extern "C" void __aeabi_vec_delete (
		void * user_array,
		void * (*destructor)(void*));


#pragma define_type_info
	class __fundamental_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__fundamental_type_info() {}
	};

#pragma define_type_info
	class __array_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__array_type_info() {}
	};

#pragma define_type_info
	class __function_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__function_type_info() {}
	};

#pragma define_type_info
	class __enum_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__enum_type_info() {}
	};

#pragma define_type_info
	class __class_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__class_type_info() {}
      	};


	struct __base_class_type_info {
		/* according to ARM EABI spec: */
	public:
		const __class_type_info *__base_type;
		long __offset_flags;

		enum __offset_flags_masks {
			__virtual_mask = 0x1,
			__public_mask = 0x2,
			__offset_shift = 8
		};
	};

#pragma define_type_info
	class __vmi_class_type_info : public __class_type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__vmi_class_type_info() {}
		unsigned int __flags;
		unsigned int __base_count;
		__base_class_type_info __base_info[1];

		enum __flags_masks {
			__non_diamond_repeat_mask = 0x1,
			__diamond_shaped_mask = 0x2
		};
	};

#pragma define_type_info
	class __si_class_type_info : public __class_type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__si_class_type_info() {}
		const __class_type_info *__base_type;
	};

#pragma define_type_info
	class __pbase_type_info : public std::type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__pbase_type_info() {}
		unsigned int __flags;
		const std::type_info *__pointee;
		enum __masks {
			__const_mask = 0x1,
			__volatile_mask = 0x2,
			__restrict_mask = 0x4,
			__incomplete_mask = 0x8,
			__incomplete_class_mask = 0x10
		};
	};

#pragma define_type_info
	class __pointer_type_info : public __pbase_type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__pointer_type_info() {}
	};

#pragma define_type_info
	class __pointer_to_member_type_info : public __pbase_type_info {
		/* according to ARM EABI spec: */
	public:
		virtual ~__pointer_to_member_type_info() {}
		const __cxxabiv1::__class_type_info *__context;
	};

#ifndef __EDG_ABI_COMPATIBILITY_VERSION
	/* Declare this only if we aren't building the run-time
	   library, due to conflicts in the specific protoype */
	
	extern "C" void* __dynamic_cast ( const void *sub,
			  const abi::__class_type_info *src,
			  const abi::__class_type_info *dst,
			  signed int src2dst_offset);
#endif

}

#endif /* __PALMSOURCE_CC_HDR_CXXABI_H */
